/*
 * Decompiled with CFR 0.152.
 */
package com.realobjects.nimbudocs.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.bouncycastle.util.encoders.Base64;
import org.imgscalr.Scalr;

public class IconDocumenter {
    private static HashMap<String, HashMap<String, BufferedImage>> imagesMap = new HashMap();

    public static void main(String[] args) {
        File infolder = new File("/Users/sebastian.giffhorn/Documents/icons-document/");
        IconDocumenter.collectImages(infolder, false);
    }

    private static void collectImages(File folder, boolean recursive) {
        String html = "<html><body><table><tr><th>Icon</th><th>Action</th><th>Description</th></tr>";
        if (folder.listFiles() != null) {
            for (File fileEntry : folder.listFiles()) {
                if (fileEntry.isDirectory() && recursive) {
                    IconDocumenter.collectImages(fileEntry, recursive);
                    continue;
                }
                if (fileEntry.isDirectory()) continue;
                System.out.println("FILE: " + fileEntry.getName());
                BufferedImage img = null;
                try {
                    img = ImageIO.read(fileEntry);
                    if (img == null) continue;
                    img = Scalr.resize(img, Scalr.Method.ULTRA_QUALITY, 32, Scalr.OP_ANTIALIAS);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)img, "png", baos);
                    baos.flush();
                    byte[] imageInByte = baos.toByteArray();
                    baos.close();
                    String imgStr = "<img src=\"data:image/png;base64," + new String(Base64.encode(imageInByte)) + "\">";
                    html = html + "\n<tr><td>" + imgStr + "</td><td>" + fileEntry.getName().split("\\.")[0] + "</td><td>Desc</td></tr>";
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        html = html + "</table></body></html>";
        System.out.println(html);
    }
}

