/*
 * Decompiled with CFR 0.152.
 */
package com.realobjects.nimbudocs.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.bouncycastle.util.encoders.Base64;
import org.imgscalr.Scalr;

public class SpriteIconCreator {
    private HashMap<String, HashMap<String, BufferedImage>> imagesMap = new HashMap();
    private String css = "";
    private String inFolder = null;
    private String outFolder = null;
    private boolean recursive = false;
    private Options options = new Options();
    private boolean base64 = false;

    public SpriteIconCreator() {
        this.options.addOption("h", "help", false, "Display help information.");
        this.options.addOption("r", "recursive", false, "Wether to recursively scan the input directory.");
        this.options.addOption("b", "base64", false, "Wether to embed the resulting image as base64 in the CSS.");
        Option u = new Option("u", "css-image-url", true, "The url used for the stitched image in the created CSS (resulting in: $URL+spriteicons.png).");
        u.setArgName("url");
        this.options.addOption(u);
    }

    public boolean run(String[] args) {
        for (String string : args) {
            System.out.println("Args: " + string);
        }
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(this.options, args);
            String[] argsLeft = cmd.getArgs();
            if (argsLeft != null && argsLeft.length >= 1) {
                this.inFolder = argsLeft[0].trim();
                if (argsLeft.length >= 2) {
                    this.outFolder = argsLeft[1].trim();
                }
            }
            if (cmd.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("java -jar spriteicons.jar", "\n", this.options, "\n", true);
                return true;
            }
            if (this.inFolder == null || this.inFolder.trim().length() == 0 || this.outFolder == null || this.outFolder.trim().length() == 0) {
                System.out.println("Try \"java -jar spriteicons.jar --help\" for more information.");
                return false;
            }
            File infolder = new File(this.inFolder);
            File outfolder = new File(this.outFolder);
            this.recursive = cmd.hasOption("r");
            this.base64 = cmd.hasOption("b");
            if (cmd.hasOption("u") && !cmd.hasOption("b")) {
                this.css = ".spriteicon {background-size: 100% auto; background-image: url('" + cmd.getOptionValue("u") + "spriteicons.png'); background-repeat: no-repeat;} ";
            }
            if (!cmd.hasOption("b") && !cmd.hasOption("u")) {
                this.css = ".spriteicon {background-size: 100% auto; background-image: url('spriteicons.png'); background-repeat: no-repeat;} ";
            }
            this.collectImages(infolder, this.recursive);
            if (this.imagesMap.size() > 0) {
                this.writeStitchedImage(outfolder, this.base64);
            }
            return true;
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            return false;
        }
    }

    private void collectImages(File folder, boolean recursive) {
        if (folder.listFiles() != null) {
            for (File fileEntry : folder.listFiles()) {
                if (fileEntry.isDirectory() && recursive) {
                    this.collectImages(fileEntry, recursive);
                    continue;
                }
                if (fileEntry.isDirectory()) continue;
                BufferedImage img = null;
                try {
                    img = ImageIO.read(fileEntry);
                    if (img == null) continue;
                    int width = img.getWidth();
                    if (width > 64) {
                        img = Scalr.resize(img, Scalr.Method.ULTRA_QUALITY, 64, Scalr.OP_ANTIALIAS);
                        width = 64;
                    }
                    if (width == 20) {
                        this.addImgToMap(fileEntry, Scalr.resize(img, Scalr.Method.ULTRA_QUALITY, 64, Scalr.OP_ANTIALIAS), 64);
                        continue;
                    }
                    if (width == 24) {
                        this.addImgToMap(fileEntry, Scalr.resize(img, Scalr.Method.ULTRA_QUALITY, 64, Scalr.OP_ANTIALIAS), 64);
                        continue;
                    }
                    if (width == 32) {
                        this.addImgToMap(fileEntry, Scalr.resize(img, Scalr.Method.ULTRA_QUALITY, 64, Scalr.OP_ANTIALIAS), 64);
                        continue;
                    }
                    if (width != 64) continue;
                    this.addImgToMap(fileEntry, img, 64);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void writeStitchedImage(File folder, boolean base64) {
        int iconAmountPerSize = this.imagesMap.get("64").size();
        System.out.println("Processing " + iconAmountPerSize + " icons...");
        int maxHeight = iconAmountPerSize * 64;
        BufferedImage stitch = new BufferedImage(64, maxHeight, 2);
        Graphics2D g = stitch.createGraphics();
        this.generateImages(1, 64, 0, g);
        try {
            if (!folder.exists()) {
                folder.mkdir();
            }
            if (!base64) {
                ImageIO.write((RenderedImage)stitch, "png", new File(folder, "spriteicons.png"));
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)stitch, "png", baos);
                baos.flush();
                byte[] imageInByte = baos.toByteArray();
                baos.close();
                this.css = ".spriteicon {background-size: 100% auto; background-image: url(data:image/png;base64," + new String(Base64.encode(imageInByte)) + "); background-repeat: no-repeat;} " + this.css;
            }
            PrintWriter out = new PrintWriter(new File(folder, "spriteicons.css"));
            out.print(this.css);
            out.close();
            System.out.println("Successfully created icon sprites.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateImages(int iconsPerRow, int size, int initialOffsetY, Graphics2D g) {
        Iterator<Map.Entry<String, BufferedImage>> it = this.imagesMap.get(String.valueOf(size)).entrySet().iterator();
        int count = 0;
        int offsetX = 0;
        int offsetY = initialOffsetY;
        while (it.hasNext()) {
            Map.Entry<String, BufferedImage> e = it.next();
            BufferedImage tile = e.getValue();
            String[] file = e.getKey().split("\\.");
            String name = file[0];
            this.css = this.css + ".spriteicon-" + name + ".tiny {background-position: -" + offsetX + "px -" + Math.round(offsetY * 20 / 64) + "px;} ";
            this.css = this.css + ".spriteicon-" + name + ".small {background-position: -" + offsetX + "px -" + Math.round(offsetY * 24 / 64) + "px;} ";
            this.css = this.css + ".spriteicon-" + name + ".medium {background-position: -" + offsetX + "px -" + Math.round(offsetY / 2) + "px;} ";
            this.css = this.css + ".spriteicon-" + name + ".large {background-position: -" + offsetX + "px -" + offsetY + "px;} ";
            if (size == 64) {
                this.css = this.css + ".spriteicon-" + name + ".large.withtext {background-position: -" + offsetX + "px -" + (offsetY + 6) + "px;} ";
            }
            g.drawImage(tile, offsetX, offsetY, size, size, null);
            if (++count != 0 && count % iconsPerRow == 0) {
                offsetY += size;
                offsetX = 0;
                continue;
            }
            if (count == 0) continue;
            offsetX += size;
        }
    }

    private void addImgToMap(File file, BufferedImage img, int width) {
        if (this.imagesMap.containsKey(Integer.toString(width))) {
            this.imagesMap.get(Integer.toString(width)).put(file.getName(), img);
        } else {
            HashMap<String, BufferedImage> hm = new HashMap<String, BufferedImage>();
            hm.put(file.getName(), img);
            this.imagesMap.put(Integer.toString(width), hm);
        }
    }
}

