/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.apache.commons.cli.PatternOptionBuilder;
import org.apache.commons.lang3.math.NumberUtils;

public class TypeHandler {
    public static Object createValue(String str, Object obj) {
        return TypeHandler.createValue(str, (Class)obj);
    }

    public static Object createValue(String str, Class clazz) {
        if (PatternOptionBuilder.STRING_VALUE == clazz) {
            return str;
        }
        if (PatternOptionBuilder.OBJECT_VALUE == clazz) {
            return TypeHandler.createObject(str);
        }
        if (PatternOptionBuilder.NUMBER_VALUE == clazz) {
            return TypeHandler.createNumber(str);
        }
        if (PatternOptionBuilder.DATE_VALUE == clazz) {
            return TypeHandler.createDate(str);
        }
        if (PatternOptionBuilder.CLASS_VALUE == clazz) {
            return TypeHandler.createClass(str);
        }
        if (PatternOptionBuilder.FILE_VALUE == clazz) {
            return TypeHandler.createFile(str);
        }
        if (PatternOptionBuilder.EXISTING_FILE_VALUE == clazz) {
            return TypeHandler.createFile(str);
        }
        if (PatternOptionBuilder.FILES_VALUE == clazz) {
            return TypeHandler.createFiles(str);
        }
        if (PatternOptionBuilder.URL_VALUE == clazz) {
            return TypeHandler.createURL(str);
        }
        return null;
    }

    public static Object createObject(String str) {
        Class<?> cl = null;
        try {
            cl = Class.forName(str);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Unable to find: " + str);
            return null;
        }
        Object instance = null;
        try {
            instance = cl.newInstance();
        }
        catch (InstantiationException cnfe) {
            System.err.println("InstantiationException; Unable to create: " + str);
            return null;
        }
        catch (IllegalAccessException cnfe) {
            System.err.println("IllegalAccessException; Unable to create: " + str);
            return null;
        }
        return instance;
    }

    public static Number createNumber(String str) {
        try {
            return NumberUtils.createNumber(str);
        }
        catch (NumberFormatException nfe) {
            System.err.println(nfe.getMessage());
            return null;
        }
    }

    public static Class createClass(String str) {
        try {
            return Class.forName(str);
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Unable to find: " + str);
            return null;
        }
    }

    public static Date createDate(String str) {
        Date date = null;
        if (date == null) {
            System.err.println("Unable to parse: " + str);
        }
        return date;
    }

    public static URL createURL(String str) {
        try {
            return new URL(str);
        }
        catch (MalformedURLException mue) {
            System.err.println("Unable to parse: " + str);
            return null;
        }
    }

    public static File createFile(String str) {
        return new File(str);
    }

    public static File[] createFiles(String str) {
        return null;
    }
}

